function LiveFitZLP(src,~,fig,handles,Spec,Energies,FWHM)
Method     = get(handles.SubMeth,'Value');
Name       =            get(handles.SubMeth,'String');
Name       = Name{Method};
FitDispOpt = get(handles.FitDispOpt,'Value');
DiffMult   = str2double(get(handles.DiffMult,'String'));
Width      = str2double(get(handles.Width,'String'));

if Method==4 && ~any(Name=='1')
    Method=5;
end

pos       = src.Position;
Ind1      = pos(1);
Ind2      = pos(1) + pos(3);

index1 = find(Energies<=Ind1,1,'last');
index2 = find(Energies>=Ind2,1,'first');

E          = Energies(index1:index2);

switch FitDispOpt
    case 1
        FWHM  = mean(FWHM,'all');
        Spec  = reshape(Spec,[size(Spec,1).*size(Spec,2),size(Spec,3)]);
        Spec  = mean(Spec,1);
        Spec  = Spec/max(Spec,[],2);
    case 2
        FWHM  = mean(FWHM,2);
        Spec  = mean(Spec,2);
        Spec  = reshape(Spec,[size(Spec,1),size(Spec,3)]);
        Spec  = Spec./max(Spec,[],2);
    case 3
        FWHM  = reshape(FWHM,[size(Spec,1).*size(Spec,2),1]);
        Spec  = reshape(Spec,[size(Spec,1).*size(Spec,2),size(Spec,3)]);
        Spec  = Spec./max(Spec,[],2);
end
Peak       = Spec(:,index1:index2);

options    = optimset('Display','off');
ZLP_load   = get(handles.LoadPeak,'UserData');

Sigma  = FWHM./(2*sqrt(2*log(2)));
Fit    = zeros(size(Spec));


%% Adjust ZLP

if ~isempty(ZLP_load{1,1})
    ZLP_load1  = ZLP_load{1,1};
    ZLP_load1  = ZLP_load1./max(ZLP_load1,[],2);
    ZLP_load1  = repmat(ZLP_load1,[size(Spec,1),1]);
    ZLP_load1  = ZLP_load1./max(ZLP_load1,[],2);
end

if ~isempty(ZLP_load{2,1})
    ZLP_load2  = ZLP_load{2,1};
    ZLP_load2  = ZLP_load2./max(ZLP_load2,[],2);
    ZLP_load2  = repmat(ZLP_load2,[size(Spec,1),1]);
    ZLP_load2  = ZLP_load2./max(ZLP_load2,[],2);
end


switch Method
    case 1
        %% Fowler-Nordheim
        parfor i=1:size(Spec,1)
            x           = [ 1 , 0 , 1, 0.5 ];
            eqn         = @(x) sum((x(1).*exp(-(E-real(x(2)))./x(3))./(1+exp(-(E-real(x(2)))./x(4))) - Peak(i,:)).^2);
            x           = fminsearch(eqn,x,options);
            Fit(i,:)    = x(1).*exp(-(Energies-real(x(2)))./x(3))./(1+exp(-(Energies-real(x(2)))./x(4)));
        end
    case 2
        %% Gauss
        parfor i=1:size(Spec,1)
            x           = [ 1 , 0 , Sigma(i)];
            eqn         = @(x) sum((x(1).*exp(-((E-x(2))./(sqrt(2).*x(3))).^2)- Peak(i,:)).^2);
            x           = fminsearch(eqn,x,options);
            Fit(i,:)     = x(1).*exp(-((Energies-x(2))./(sqrt(2).*x(3))).^2);
        end
    case 3
        %% Weibull
        parfor i=1:size(Spec,1)
            x           =  [0.00044883, 1.7517 , -1.8317 ,14.204 ,  3.2323e-06];
            eqn         = @(x) sum(( x(1) .* ((E-x(2))./x(3)).^(x(4)-1).* exp(((E-x(2))./x(3)).^x(4))+x(5) - Peak(i,:)).^2);
            x           = fminsearch(eqn,x,options);
            Fit(i,:)    =  x(1) .* ((Energies-x(2))./x(3)).^(x(4)-1).* exp(((Energies-x(2))./x(3)).^x(4));
        end
    case 4
        %% Loaded ZLP1
        ZLPfit1     = ZLP_load1(:,index1:index2);
        parfor i=1:size(Spec,1)
            x           =  1.1;
            eqn         = @(x) sum((abs(x(1)).*ZLPfit1(i,:) - Peak(i,:)).^2);
            x           = fminsearch(eqn,x,options);
            Fit(i,:)    = abs(x(1)).*ZLP_load1(i,:);
        end
    case 5
        %% Loaded ZLP2
        ZLPfit2     = ZLP_load2(:,index1:index2);
        parfor i=1:size(Spec,1)
            x           =  1.1;
            eqn         = @(x) sum((abs(x(1)).*ZLPfit2(i,:) - Peak(i,:)).^2);
            x           = fminsearch(eqn,x,options);
            Fit(i,:)    = abs(x(1)).*ZLP_load2(i,:);
        end
        
    case 6
        %% Dual ZLP
        ZLPfit1     = ZLP_load1(:,index1:index2);
        ZLPfit2     = ZLP_load2(:,index1:index2);
        parfor i=1:size(Spec,1)
            x           = [0.5 , 0.5];
            eqn         = @(x) sum((abs(x(1)).*ZLPfit1(i,:)+ abs(x(2)).*ZLPfit2(i,:) - Peak(i,:)).^2);
            x           = fminsearch(eqn,x,options);
            Fit(i,:)    = abs(x(1)).*ZLP_load1(i,:) + abs(x(2)).*ZLP_load2(i,:);
        end
end

fit       = Fit./sum(Spec,2);
clearvars Fit
spec      = Spec./sum(Spec,2);
res       = (spec-fit)*DiffMult;
ResPos    = res;
ResPos(ResPos<0)=0;
ResNeg    = res;
ResNeg(ResPos>0)=0;
ResPos    = mean(ResPos,1);
ResNeg    = mean(ResNeg,1);
spec      = mean(spec,1);
fit       = mean(fit,1);

%% Plot
figure(fig)
hold on
h = findobj(gca,'type','line');
delete(h);

plot(Energies,spec,'Color','b');
hold on
plot(Energies,fit,'Color','m');
plot(Energies,ResPos,'Color','g');
plot(Energies,ResNeg,'Color','r');
plot(Energies,zeros(size(Energies)),'--','Color','k');
legend('Normed mean Spectrum','Fit',['Pos. Difference x',num2str(DiffMult)],['Neg. Difference x',num2str(DiffMult)]);
ylabel('mean Loss probability [a.u.]');
xlabel('Loss energy [eV]');

hold off

xlim([-mean(FWHM,'all')*Width/2,mean(FWHM,'all')*Width/2]);
ylim([-max(spec)/2,max(spec).*1.25])

end